﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class ConfirmExitDialogController : MonoBehaviour
{
    public static ConfirmExitDialogController instance;

    protected bool isActive = false;
    protected GameObject panel;
    protected GameObject selector;
    protected Transform options;

    protected bool isBaking;
    protected int selectedOption;

    protected int restTime;
    protected int temperature;
    protected int bakeTime;

    protected float animationRestTime;
    protected float animationTemperature;
    protected float animationBakeTime;

    private void OnEnable()
    {
        instance = this;
        panel = transform.GetChild(0).gameObject;
        selector = panel.transform.GetChild(0).gameObject;
        options = panel.transform.GetChild(1);
    }

    public void Activate()
    {
        isActive = true;

        panel.SetActive(true);
        SelectOption(0);
    }

    public void Deactivate()
    {
        isActive = false;
        panel.SetActive(false);
    }

    protected void SelectOption(int option)
    {
        selectedOption = option;
        Transform optionTransform = options.GetChild(selectedOption);
        selector.transform.position = optionTransform.position + 16f * Vector3.up;
    }

    // Update is called once per frame
    void Update()
    {
        if (!isActive)
        {
            return;
        }

        if (Input.GetButtonDown("Left"))
        {
            SelectOption(selectedOption = (selectedOption + options.childCount - 1) % options.childCount);
        }

        if (Input.GetButtonDown("Right"))
        {
            SelectOption((selectedOption + 1) % options.childCount);
        }

        if (Input.GetButtonDown("Interact"))
        {
            if (selectedOption == 1)
            {
                SceneManager.LoadScene("End");
            }
            else
            {
                GameController.instance.StopConfirmExitDialogController();
            }
        }
    }
}
